/**
 * The class Account describes a bank account.
 * Contract: The balance is guaranteed to be >= 0.
 *
 * This example demonstrates encapsulation, 
 * and the use of final, static, overload methods
 * and the use of the reference "this".
 */

public class Account {

	// Private fields
	private double balance;
	private String name;
	// Static field, common to all all objects of 
	// type Account
	private static double interest = 0.25; 
	
	// Constructors
	public Account(String name, double balance) {
		this.name = name; 
		this.balance = balance; 
	}
	
	public Account(String name) {
		this.name = name; 
		this.balance = 0.0; 
	}
	
	// Accessors
	public double getBalance()	{	return balance;	}
	public String getName()		{	return name;	}
	
	// Static methods, to access/change the (static) interest
	public static double getInterest() {
		return interest;
	}
	
	public static void setInterest(double newInterest) {
		interest = newInterest;
	}
	
	// Mutators
	public void deposit(int amount) {
		if(amount < 0 ) {
			System.out.println("Deposit not allowed!");
		}
		else {
			balance += amount;
		}
	}
	
	public void withdraw(int amount) {
		if(amount > balance || amount < 0) {
			System.out.println("Withdrawal not allowed!");
		}
		else {
			balance -= amount;
		}
	}
	
	// Other methods
	public void addInterest() {
		balance = balance*(1.0+interest/100.0);
	}
	
	public String toString() {
		String info = 
			"Name: " + name + ", balance = " + balance;
		return info;
	} 
		
	// This method makes use of the reference "this" to 
	// pass a reference to the calling object itself
	// to another method, println(...)
	public void printInfo() {
		System.out.println(this);
	}
}